const ASCII_RANGE_REGEX = /^[\x00-\x7F]*$/;

function isInternationalUsername(username: string): boolean {
  return !ASCII_RANGE_REGEX.test(username);
}

export interface UsernameDisplayData {
  usernameDisplay: string;
  isIntl: boolean;
}

export function getUsernameDisplay(
  displayName: string | null,
  rawUsername: string,
): UsernameDisplayData {
  let usernameDisplay = displayName;
  let isIntl = false;
  if (usernameDisplay) {
    if (isInternationalUsername(usernameDisplay)) {
      isIntl = true;
    }
  } else {
    usernameDisplay = rawUsername;
  }
  return { usernameDisplay, isIntl };
}
