import * as React from 'react';
import { Provider } from 'react-intl-redux';
import { Store } from 'react-redux';
import { BrowserRouter } from 'react-router-dom';

import { RootState } from 'mweb/common/reducers/root';
import TrackingProvider from 'mweb/common/tracking/trackingProvider';
import { LatencyReporter } from 'mweb/common/latency/latencyReporter';
import { LatencyProvider } from 'mweb/common/latency/latencyProvider';
import Router from 'mweb/common/router';

export interface AppProps {
  store: Store<RootState>;
  latencyReporter: LatencyReporter;
}

export class App extends React.Component<AppProps, {}> {
  render(): JSX.Element {
    return (
      <Provider store={this.props.store}>
        <LatencyProvider latencyReporter={this.props.latencyReporter}>
          <TrackingProvider>
            <BrowserRouter>
              <Router />
            </BrowserRouter>
          </TrackingProvider>
        </LatencyProvider>
      </Provider>
    );
  }
}
