import * as React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-intl-redux';

import { initializeIntl } from 'mweb/client/initializeIntl';
import { setupClientStoreAfterRender } from 'mweb/client/setupClientStoreAfterRender';
import configureStore from 'mweb/common/stores/configureStore';
import { ChatEmbed } from 'mweb/common/containers/chatEmbed';
import {
  getOrCreateDeviceID,
  getOrCreateSessionID,
} from 'mweb/common/utils/uniqueIDs';

(window.__PRELOADED_STATE__.device.deviceID as any) = getOrCreateDeviceID();
(window.__PRELOADED_STATE__.device.sessionID as any) = getOrCreateSessionID();
const store = configureStore(window.__PRELOADED_STATE__);

initializeIntl();

(ReactDOM as any).hydrate(
  <Provider store={store}>
    <ChatEmbed />
  </Provider>,
  document.getElementById('app'),
);

setupClientStoreAfterRender(store);
