import { addLocaleData } from 'react-intl';

export function initializeIntl(): void {
  if (Intl.hasOwnProperty('__disableRegExpRestore')) {
    (Intl as any).__disableRegExpRestore();
  }

  if (window.ReactIntlLocaleData) {
    Object.keys(window.ReactIntlLocaleData).forEach(lang => {
      addLocaleData(window.ReactIntlLocaleData[lang]);
    });
  }
}
