import { Store } from 'redux';

import { RootState, chatTargetDetails } from 'mweb/common/reducers/root';
import { platformSwitchToClient } from 'mweb/common/actions/platform';
import { buildSwitchToDesktopSubscriber } from 'mweb/client/subscribers';
import { channelsDataUpdateChannelHostingStatus } from 'mweb/common/actions/data/channels';
import { chatWorkerBridge } from 'mweb/chat/chatWorkerBridge';

const CHAT_BUFFER_SIZE = 100;

export function setupClientStoreAfterRender(store: Store<RootState>): void {
  store.subscribe(buildSwitchToDesktopSubscriber(store, window, document));
  store.subscribe(
    chatWorkerBridge({
      store,
      chatTargetDetails,
      hostingHandler: (channel: string, hostedChannel: string) =>
        store.dispatch(
          channelsDataUpdateChannelHostingStatus(channel, hostedChannel),
        ),
      bufferSize: CHAT_BUFFER_SIZE,
    }),
  );

  // cause client-specific re-render
  store.dispatch(
    platformSwitchToClient({
      userAgent: navigator.userAgent,
    }),
  );
}
