import { Store } from 'redux';

import { getIsOptedOut, RootState } from 'mweb/common/reducers/root';
import { setCookie } from 'mweb/common/utils/cookie';

export const REDIRECT_QUERY =
  '?tt_medium=twitch_mobileweb&tt_content=channel_nav&no-mobile-redirect=true';

export function buildSwitchToDesktopSubscriber(
  store: Store<RootState>,
  window: Window,
  document: Document,
): () => void {
  return () => {
    const cookie = getIsOptedOut(store.getState());
    if (!cookie) {
      return;
    }

    const THREE_HOURS_IN_SECONDS = 60 * 60 * 3;
    setCookie(cookie, 'true', THREE_HOURS_IN_SECONDS, document);
    window.location.href = `https://twitch.tv${window.location
      .pathname}${REDIRECT_QUERY}`;
  };
}
