# Common code

If you are here then you are probably in the right place. A goal for developers
is that code that _can_ be common _should_ be common.

## Organization

The _current_ structure of this directory follows the 
[Redux Book's](http://redux.js.org/docs/advanced/ExampleRedditAPI.html) approach
This means that we separate the parts of the application by part, but with the
addition of type data from typescript:
* actions - Both the action creator and the action's type definition.
* components - component, style for the component, etc.
* containers - components that are explicitly tied to the redux store, style,
  etc.
* reducers - Reducers built combined using `combineReducers`.
* stores - Store configuration logic.
* utils - various utility files.

## Possible future organization

It is possible that we'll adopt the Phoenix Project's structure. We did once
already, but then they changed it so we'll wait until they finish deciding
before spending the effort to do it again. But, it is likely they'll move to
a pod-like format. Once they figure out exactly how that works we'll consider
adopting. This only matters to you, the developer of today because it might
mean that a future you has to deal with all the structure being upended.
