import { Dispatch } from 'redux';

import { RootState } from 'mweb/common/reducers/root';
import { Location } from 'mweb/common/reducers/app';
import { navigationUpdateLocation } from 'mweb/common/actions/navigation';
import { channelsDataGetPage } from 'mweb/common/actions/data/channels';

export const CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE =
  'CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE';
export interface ChannelDirectoryPageGameAliasUpdatedAction {
  type: typeof CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE;
  payload: {
    gameAlias: string;
  };
}

export type ChannelDirectoryPageAction = ChannelDirectoryPageGameAliasUpdatedAction;

export function channelDirectoryPageTransition(
  gameAlias: string,
): (dispatch: Dispatch<RootState>) => Promise<void> {
  return async dispatch => {
    dispatch(channelDirectoryPageUpdateGameAlias(gameAlias));
    await dispatch(channelsDataGetPage(gameAlias, { isOnePageEnough: true }));
    dispatch(navigationUpdateLocation(Location.DirectoryGame));
  };
}

export function channelDirectoryPageUpdateGameAlias(
  gameAlias: string,
): ChannelDirectoryPageGameAliasUpdatedAction {
  return {
    type: CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE,
    payload: {
      gameAlias,
    },
  };
}
