import { Dispatch } from 'redux';

import { RootState } from 'mweb/common/reducers/root';
import { Location } from 'mweb/common/reducers/app';
import { navigationUpdateLocation } from 'mweb/common/actions/navigation';
import { eventsDataFetchEvent } from 'mweb/common/actions/data/events';

export const EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE =
  'EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE';
export interface EventDetailsPageEventUpdatedAction {
  type: typeof EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE;
  payload: {
    eventID: string;
  };
}

export type EventInteractionLocation = Location.EventDetails;

export type EventSharedMedium = 'twitter' | 'facebook' | 'reddit' | 'url';
export interface EventSharedPayload {
  medium: EventSharedMedium;
  location: EventInteractionLocation;
}

export const EVENT_DETAILS_PAGE_EVENT_SHARED_ACTION_TYPE =
  'EVENT_DETAILS_PAGE_EVENT_SHARED_ACTION_TYPE';
export interface EventDetailsPageEventSharedAction {
  type: typeof EVENT_DETAILS_PAGE_EVENT_SHARED_ACTION_TYPE;
  payload: EventSharedPayload;
}

export type NotificationRequest =
  | 'remind_me_open_modal'
  | 'email_reminder_on'
  | 'email_reminder_off'
  | 'apple_calendar'
  | 'google_calendar'
  | 'outlook_calendar'
  | 'outlook_online_calendar'
  | 'yahoo_calendar';
export interface NotificationRequestedPayload {
  request: NotificationRequest;
  location: EventInteractionLocation;
}

export const EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_ACTION_TYPE =
  'EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_ACTION_TYPE';
export interface EventDetailsPageNotificationRequestedAction {
  type: typeof EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_ACTION_TYPE;
  payload: NotificationRequestedPayload;
}

export type EventDetailsPageAction =
  | EventDetailsPageEventUpdatedAction
  | EventDetailsPageEventSharedAction
  | EventDetailsPageNotificationRequestedAction;

export function eventDetailsPageTransition(
  eventID: string,
): (dispatch: Dispatch<RootState>) => Promise<void> {
  return async dispatch => {
    dispatch(eventDetailsPageUpdateEvent(eventID));
    await dispatch(eventsDataFetchEvent(eventID));
    dispatch(navigationUpdateLocation(Location.EventDetails));
  };
}

export function eventDetailsPageUpdateEvent(
  eventID: string,
): EventDetailsPageEventUpdatedAction {
  return {
    type: EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE,
    payload: {
      eventID,
    },
  };
}

export function eventDetailsPageShareEvent(
  medium: EventSharedMedium,
  location: EventInteractionLocation,
): EventDetailsPageEventSharedAction {
  return {
    type: EVENT_DETAILS_PAGE_EVENT_SHARED_ACTION_TYPE,
    payload: {
      medium,
      location,
    },
  };
}

export function eventDetailsPageRequestNotification(
  request: NotificationRequest,
  location: EventInteractionLocation,
): EventDetailsPageNotificationRequestedAction {
  return {
    type: EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_ACTION_TYPE,
    payload: {
      request,
      location,
    },
  };
}

// Tracked events

export const EVENT_DETAILS_PAGE_EVENT_SHARED_EVENT_TYPE =
  'EVENT_DETAILS_PAGE_EVENT_SHARED_EVENT_TYPE';
export interface EventDetailsPageEventSharedEvent {
  type: typeof EVENT_DETAILS_PAGE_EVENT_SHARED_EVENT_TYPE;
  payload: EventSharedPayload;
}

export const EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_EVENT_TYPE =
  'EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_EVENT_TYPE';
export interface EventDetailsPageNotificationRequestedEvent {
  type: typeof EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_EVENT_TYPE;
  payload: NotificationRequestedPayload;
}
