import { Dispatch } from 'redux';

import { RootState } from 'mweb/common/reducers/root';
import { Location } from 'mweb/common/reducers/app';
import { navigationUpdateLocation } from 'mweb/common/actions/navigation';
import { gamesDataGetPage } from 'mweb/common/actions/data/games';

export function gameDirectoryPageTransition(): (
  dispatch: Dispatch<RootState>,
) => Promise<void> {
  return async dispatch => {
    await dispatch(gamesDataGetPage({ isOnePageEnough: true }));
    dispatch(navigationUpdateLocation(Location.DirectoryMainGame));
  };
}
