import { Dispatch } from 'redux';

import { RootState } from 'mweb/common/reducers/root';
import { Location } from 'mweb/common/reducers/app';
import { navigationUpdateLocation } from 'mweb/common/actions/navigation';
import { vodsDataFetchVOD } from 'mweb/common/actions/data/vods';

export const VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE =
  'VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE';
export interface VODViewerPageVODUpdatedAction {
  type: typeof VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE;
  payload: {
    vodID: string;
  };
}

export type VODViewerPageAction = VODViewerPageVODUpdatedAction;

export function vodViewerPageTransition(
  vodID: string,
): (dispatch: Dispatch<RootState>) => Promise<void> {
  return async dispatch => {
    dispatch(vodViewerPageUpdateVOD(vodID));
    await dispatch(vodsDataFetchVOD(vodID));
    dispatch(navigationUpdateLocation(Location.VOD));
  };
}

export function vodViewerPageUpdateVOD(
  vodID: string,
): VODViewerPageVODUpdatedAction {
  return {
    type: VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE,
    payload: {
      vodID,
    },
  };
}
