import { Dispatch } from 'redux';

import { RootState } from 'mweb/common/reducers/root';
import { Location } from 'mweb/common/reducers/app';
import { SpadeEvent } from 'mweb/common/tracking/tracker';

export const TRACKING_PAGE_VIEW_TRACKED_ACTION_TYPE =
  'TRACKING_EVENTS_PAGE_VIEW_TRACKED_ACTION_TYPE';
interface TrackingPageViewTrackedAction {
  readonly type: typeof TRACKING_PAGE_VIEW_TRACKED_ACTION_TYPE;
  readonly payload: {
    readonly referrer: string | undefined;
  };
}

export const TRACKING_PROFILE_PAGE_VIEW_TRACKED_ACTION_TYPE =
  'TRACKING_PROFILE_PAGE_VIEW_TRACKED_ACTION_TYPE';
interface TrackingProfilePageViewTrackedAction {
  readonly type: typeof TRACKING_PROFILE_PAGE_VIEW_TRACKED_ACTION_TYPE;
}

export interface TwitchTrackingParams {
  tt_content: string | undefined;
  tt_medium: string | undefined;
}

export const TRACKING_PARAMS_CAPTURED_ACTION_TYPE =
  'TRACKING_PARAMS_CAPTURED_ACTION_TYPE';
export interface TrackingCampaignParamsCapturedAction {
  readonly type: typeof TRACKING_PARAMS_CAPTURED_ACTION_TYPE;
  readonly payload: TwitchTrackingParams;
}

export const TRACKING_PARAMS_CLEARED_ACTION_TYPE =
  'TRACKING_PARAMS_CLEARED_ACTION_TYPE';
export interface TrackingClearedTrackingParamsAction {
  readonly type: typeof TRACKING_PARAMS_CLEARED_ACTION_TYPE;
}

export interface UITrackingPayload {
  interactionMedium: string;
  interactionContent: string;
  interactionTargetPath?: string;
  interactionSubscribe?: boolean;
}

export const TRACKING_CLICK_TRACKED_ACTION_TYPE =
  'TRACKING_CLICK_TRACKED_ACTION_TYPE';
export interface TrackingClickTrackedAction {
  readonly type: typeof TRACKING_CLICK_TRACKED_ACTION_TYPE;
  readonly payload: UITrackingPayload;
}

export const TRACKING_SUBSCRIBE_TRACKED_ACTION_TYPE =
  'TRACKING_SUBSCRIBE_TRACKED_ACTION_TYPE';
export interface TrackingSubscribeTrackedAction {
  readonly type: typeof TRACKING_SUBSCRIBE_TRACKED_ACTION_TYPE;
  readonly payload: UITrackingPayload;
}

export const TRACKING_LATENCY_TRACKED_ACTION_TYPE =
  'TRACKING_LATENCY_TRACKED_ACTION_TYPE';
export interface TrackingLatencyTrackedAction {
  readonly type: typeof TRACKING_LATENCY_TRACKED_ACTION_TYPE;
  readonly payload: SpadeEvent;
}

export type TrackingAction =
  | TrackingProfilePageViewTrackedAction
  | TrackingPageViewTrackedAction
  | TrackingCampaignParamsCapturedAction
  | TrackingClearedTrackingParamsAction
  | TrackingClickTrackedAction
  | TrackingSubscribeTrackedAction
  | TrackingLatencyTrackedAction;

export function trackingTrackPageView(
  location: Location,
): (dispatch: Dispatch<RootState>) => void {
  return dispatch => {
    dispatch(trackingPageViewTrackedActionBuilder());

    if (location === Location.ChannelProfile) {
      // trigger the special profile_page_view metrics spade event
      dispatch(trackingTrackProfilePageView());
    }

    dispatch(trackingClearTrackingParams());
  };
}

export function trackingPageViewTrackedActionBuilder(): TrackingPageViewTrackedAction {
  return {
    type: TRACKING_PAGE_VIEW_TRACKED_ACTION_TYPE,
    payload: {
      referrer: typeof document !== 'undefined' ? document.referrer : undefined,
    },
  };
}

export function trackingTrackProfilePageView(): TrackingProfilePageViewTrackedAction {
  return {
    type: TRACKING_PROFILE_PAGE_VIEW_TRACKED_ACTION_TYPE,
  };
}

export function trackingCaptureTrackingParams(
  params: TwitchTrackingParams,
): TrackingCampaignParamsCapturedAction {
  return {
    type: TRACKING_PARAMS_CAPTURED_ACTION_TYPE,
    payload: params,
  };
}

export function trackingClearTrackingParams(): TrackingClearedTrackingParamsAction {
  return {
    type: TRACKING_PARAMS_CLEARED_ACTION_TYPE,
  };
}

export function trackingTrackClick(
  payload: UITrackingPayload,
): (dispatch: Dispatch<RootState>) => void {
  return dispatch => {
    if (payload.interactionSubscribe) {
      dispatch(trackingTrackSubscribe(payload));
    }

    dispatch(trackingClickTrackedActionBuilder(payload));
  };
}

export function trackingClickTrackedActionBuilder(
  payload: UITrackingPayload,
): TrackingClickTrackedAction {
  return {
    type: TRACKING_CLICK_TRACKED_ACTION_TYPE,
    payload,
  };
}

export function trackingTrackSubscribe(
  payload: UITrackingPayload,
): TrackingSubscribeTrackedAction {
  return {
    type: TRACKING_SUBSCRIBE_TRACKED_ACTION_TYPE,
    payload,
  };
}

export function trackingTrackLatency(
  payload: SpadeEvent,
): TrackingLatencyTrackedAction {
  return {
    type: TRACKING_LATENCY_TRACKED_ACTION_TYPE,
    payload,
  };
}
