import * as React from 'react';
import omit from 'lodash-es/omit';
import { TrackingInteractionContentProps } from 'mweb/common/tracking/withTracking';
import { getComponentName } from 'mweb/common/utils/getComponentName';

export interface ListItemOwnProps {
  position: number;
}

type TransformedProps<P extends TrackingInteractionContentProps> = ObjectDiff<
  P,
  TrackingInteractionContentProps
> &
  ListItemOwnProps;

export function asListItem<P extends TrackingInteractionContentProps>(
  WrappedComponent: React.ComponentType<P>,
): React.ComponentType<TransformedProps<P>> {
  return class AsListItem extends React.Component<TransformedProps<P>> {
    static displayName: string = `AsListItem(${getComponentName(
      WrappedComponent,
    )})`;
    get interactionContent(): string {
      return `position_${this.props.position}`;
    }
    render(): JSX.Element {
      return (
        <WrappedComponent
          {...omit(this.props, 'position')}
          interactionContent={this.interactionContent}
        />
      );
    }
  };
}
