import * as React from 'react';
import { connect } from 'react-redux';

import { RootState } from 'mweb/common/reducers/root';
import {
  ExperimentNames,
  ExperimentGroups,
} from 'mweb/common/actions/experiments';
import { Experiment, Treatment } from 'mweb/common/containers/experiment';
import { BranchTimedTracker, BranchTimedTrackerProps } from 'branch-io';

interface BranchTimedTrackerStateProps
  extends Pick<BranchTimedTrackerProps, 'sessionID' | 'deviceID'> {}

interface BranchTimedTrackerOwnProps
  extends Pick<BranchTimedTrackerProps, 'delaySecondsUntilTrack' | 'event'> {}

interface BranchTimedTrackerWrapperProps
  extends BranchTimedTrackerStateProps,
    BranchTimedTrackerOwnProps {}

class BranchTimedTrackerWrapperBase extends React.Component<
  BranchTimedTrackerWrapperProps
> {
  render(): JSX.Element {
    return <BranchTimedTracker {...this.props} />;
  }
}

function mapStateToProps(state: RootState): BranchTimedTrackerStateProps {
  return {
    sessionID: state.device.sessionID,
    deviceID: state.device.deviceID,
  };
}

const BranchTimedTrackerWrapper = connect(mapStateToProps)(
  BranchTimedTrackerWrapperBase,
) as React.ComponentClass<BranchTimedTrackerOwnProps>;

export class BranchTimedTrackerExperiment extends React.Component<
  BranchTimedTrackerOwnProps
> {
  render(): JSX.Element {
    return (
      <Experiment experimentName={ExperimentNames.Branch}>
        <Treatment group={ExperimentGroups.Treatment}>
          <BranchTimedTrackerWrapper {...this.props} />
        </Treatment>
      </Experiment>
    );
  }
}
