import * as React from 'react';
import { Layout, Button, Balloon } from 'twitch-core-ui';

import { ClientOnly } from 'mweb/common/containers/clientOnly';
import { ToggleBalloonWrapper } from 'mweb/common/components/more-ui/toggleBallonWrapper';
import { InteractionMedium } from 'mweb/common/tracking/extendInteractionMedium';

interface DropdownProps {
  dropdownItems?: React.ReactNode;
  onClick?: React.EventHandler<React.MouseEvent<HTMLSpanElement>>;
  interactionMedium?: string;
}

export class Dropdown extends React.PureComponent<DropdownProps, {}> {
  get balloonContents(): JSX.Element {
    const items = <Layout>{this.props.dropdownItems}</Layout>;

    if (this.props.interactionMedium) {
      return (
        <InteractionMedium medium={this.props.interactionMedium}>
          {items}
        </InteractionMedium>
      );
    }

    return items;
  }

  render(): JSX.Element {
    return (
      <ClientOnly>
        <ToggleBalloonWrapper>
          <Button dropdown onClick={this.props.onClick}>
            {this.props.children}
          </Button>
          <Balloon tailOffset={6} noTail={true}>
            {this.balloonContents}
          </Balloon>
        </ToggleBalloonWrapper>
      </ClientOnly>
    );
  }
}
