import * as React from 'react';
import { FormattedMessage } from 'react-intl';
import { Text, Layout, Display, AlignItems } from 'twitch-core-ui';

import { TimedToast } from 'mweb/common/components/timedToast';

export const OFFLINE_NOTIFICATION_TIME_IN_SECONDS = 20;

interface ChannelOfflineToastProps {
  displayName: string;
}

export function ChannelOfflineToast({
  displayName,
}: ChannelOfflineToastProps): JSX.Element {
  return (
    <TimedToast secondsVisible={OFFLINE_NOTIFICATION_TIME_IN_SECONDS}>
      <Layout
        display={Display.Flex}
        alignItems={AlignItems.Center}
        padding={1}
        fullHeight={true}
      >
        <Text bold={true}>
          <FormattedMessage
            defaultMessage="You missed {channel}'s show, catch up below!"
            id="channel-offline-toast-message"
            values={{
              channel: displayName,
            }}
          />
        </Text>
      </Layout>
    </TimedToast>
  );
}
