import * as React from 'react';
import { FormattedMessage } from 'react-intl';

interface DeclineUpsellProps {
  onClick: React.EventHandler<React.MouseEvent<HTMLAnchorElement>>;
}

if (process.env.BROWSER) {
  require('./declineUpsell.sass');
}

export function DeclineUpsell(
  props: DeclineUpsellProps,
): React.ReactElement<{}> {
  return (
    <a className="decline_upsell qa-decline_upsell" onClick={props.onClick}>
      <FormattedMessage
        id="decline-upsell--message"
        defaultMessage="Switch to Desktop Mode"
      />
    </a>
  );
}
