import * as React from 'react';
import { FormattedMessage } from 'react-intl';

if (process.env.BROWSER) {
  require('./internalError.sass');
}

export class InternalError extends React.Component<{}, {}> {
  render(): JSX.Element {
    return (
      <div className="error-page">
        <div className="error-message">
          <FormattedMessage
            defaultMessage="Looks like something went wrong, please try again at another time."
            id="internal-error--message"
          />
        </div>
        <img
          className="error-image"
          src="/static/images/error-500.png"
          srcSet="/static/images/error-500.png 1x, /static/images/error-500@2x.png 2x"
        />
      </div>
    );
  }
}
