import * as React from 'react';
import { FormattedMessage } from 'react-intl';

if (process.env.BROWSER) {
  require('./notFound.sass');
}

export class NotFound<P, S> extends React.Component<P, S> {
  render(): JSX.Element {
    return (
      <div className="not-found-page">
        <div className="error-message">
          <FormattedMessage
            id="not-found--message"
            defaultMessage="Sorry, that page is in another castle!"
          />
        </div>
        <img
          className="error-image"
          src="/static/images/error-404.png"
          srcSet="/static/images/error-404.png 1x, /static/images/error-404@2x.png 2x"
        />
      </div>
    );
  }
}
