import * as React from 'react';
import { Layout, Position } from 'twitch-core-ui';
import LatencyTrackedImage from 'mweb/common/latency/latencyTrackedImage';
import { buildStringFromTemplate } from 'mweb/common/utils/imageUtils';
import { EventCalendar } from 'mweb/common/components/eventCalendar';

if (process.env.BROWSER) {
  require('./eventBanner.sass');
}

export const COVER_IMAGE_HEIGHT = 360;
export const COVER_IMAGE_WIDTH = 640;

export interface EventBannerProps {
  coverImageTemplateURL: string;
  startTime: Date;
}

export function EventBanner(props: EventBannerProps): JSX.Element {
  const buildCoverImageURL = (multiplier: number) =>
    buildStringFromTemplate(
      props.coverImageTemplateURL,
      multiplier * COVER_IMAGE_WIDTH,
      multiplier * COVER_IMAGE_HEIGHT,
    );

  return (
    <Layout position={Position.Relative}>
      <LatencyTrackedImage
        className="event-cover-image"
        src={buildCoverImageURL(1)}
        srcSet={`
          ${buildCoverImageURL(1)},
          ${buildCoverImageURL(2)} 2x,
          ${buildCoverImageURL(3)} 3x,
          ${buildCoverImageURL(4)} 4x,
        `}
      />
      <Layout
        margin={{ left: 2, top: 1 }}
        position={Position.Absolute}
        attachLeft
        attachTop
      >
        <EventCalendar date={props.startTime} />
      </Layout>
    </Layout>
  );
}
