import * as React from 'react';
import { FormattedDate } from 'react-intl';
import { Layout, StyledLayout, TextAlign } from 'twitch-core-ui';

import { ClientOnly } from 'mweb/common/containers/clientOnly';

if (process.env.BROWSER) {
  require('./eventCalendar.sass');
}

interface EventCalendarProps {
  date: Date;
}

// The time zone can be different on the client versus the server. That means
// rendering the event calendar is not a pure function of the app state since
// calls to FormattedDate will render based on the global state of the time
// zone. Because of this we should just not attempt to render the date or time
// when on the server.
export function EventCalendar(props: EventCalendarProps): JSX.Element {
  return (
    <ClientOnly hasLatencyTrackedChildren>
      <StyledLayout
        className="event-calendar"
        elevation={1}
        textAlign={TextAlign.Center}
      >
        <Layout className="event-calendar__month">
          <FormattedDate value={props.date} month="short" />
        </Layout>
        <Layout className="event-calendar__day">
          <FormattedDate value={props.date} day="numeric" />
        </Layout>
      </StyledLayout>
    </ClientOnly>
  );
}
