import * as React from 'react';
import { FormattedMessage } from 'react-intl';
import { Layout, InjectLayout, Text, TextType } from 'twitch-core-ui';

import { Timespan } from 'mweb/common/components/timespan';
import { ClientOnly } from 'mweb/common/containers/clientOnly';
import { PremiereStatus } from 'mweb/common/reducers/data/events';

if (process.env.BROWSER) {
  require('./eventInfo.sass');
}

export interface EventInfoProps {
  title: string;
  startTime: Date;
  endTime: Date;
  premiereStatus?: PremiereStatus;
}

export function EventInfo(props: EventInfoProps): JSX.Element {
  return (
    <Layout>
      <InjectLayout margin={{ bottom: 0.5 }}>
        <Text type={TextType.H2} bold>
          {props.title}
        </Text>
      </InjectLayout>
      {props.premiereStatus && (
        <Text className="premiere-title" type={TextType.Span}>
          <FormattedMessage id="event--premiere" defaultMessage="Premiere" />
        </Text>
      )}
      <Layout className="event-timespan" margin={{ bottom: 0.5 }}>
        <ClientOnly hasLatencyTrackedChildren>
          <Timespan start={props.startTime} end={props.endTime} />
        </ClientOnly>
      </Layout>
    </Layout>
  );
}
