import * as React from 'react';

import Spinner from 'mweb/common/components/spinner';

if (process.env.BROWSER) {
  require('./initialLoadWrapper.sass');
}

export interface InitialLoadWrapperProps {
  isLoading: boolean;
}

export default function InitialLoadWrapper<P>(
  WrappedComponent: React.ComponentType<P>,
): React.ComponentType<P & InitialLoadWrapperProps> {
  return class InitialLoadingComponent extends React.Component<
    P & InitialLoadWrapperProps,
    {}
  > {
    render(): JSX.Element {
      return (
        <div>
          {this.props.isLoading ? (
            <Spinner name="cube-grid" wrapperClassName="load-wrapper-spinner" />
          ) : null}
          <div style={this.props.isLoading ? { display: 'none' } : {}}>
            <WrappedComponent {...this.props} />
          </div>
        </div>
      );
    }
  };
}
