import * as React from 'react';
import {
  Layout,
  InjectLayout,
  StyledLayout,
  Background,
  Button,
  SVG,
  SVGAsset,
  SVGType,
  Text,
  TextType,
  Display,
  FlexDirection,
  AlignItems,
  Color,
} from 'twitch-core-ui';
import { FormattedMessage } from 'react-intl';

import { withTracking, TrackingProps } from 'mweb/common/tracking/withTracking';
import { buildGameDirectoryPath } from 'mweb/common/utils/pathBuilders';
import { extendInteractionMedium } from 'mweb/common/tracking/extendInteractionMedium';

export interface ProfileEmptyStateProps extends TrackingProps {}

export const INTERACTION_CONTENT_BROWSE_TWITCH = 'browse_twitch';
const INTERACTION_MEDIUM = 'empty_state';

export class ProfileEmptyStateBase extends React.PureComponent<
  ProfileEmptyStateProps,
  {}
> {
  render(): JSX.Element {
    return (
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        alignItems={AlignItems.Center}
        padding={2}
      >
        <SVG
          asset={SVGAsset.NavChannels}
          height={40}
          width={40}
          type={SVGType.Alt2}
        />
        <InjectLayout margin={{ y: 1 }}>
          <Text type={TextType.H4} color={Color.Alt2} bold>
            <FormattedMessage
              id="channel-has-no-videos"
              defaultMessage="This channel has no videos"
            />
          </Text>
        </InjectLayout>
        <Text type={TextType.P} color={Color.Alt2}>
          <FormattedMessage
            id="its-quiet"
            defaultMessage="It's quiet... too quiet"
          />
        </Text>
        <StyledLayout background={Background.Accent} margin={{ top: 1 }}>
          <Button
            linkTo={buildGameDirectoryPath()}
            onClick={this.props.trackClick({
              interactionContent: INTERACTION_CONTENT_BROWSE_TWITCH,
            })}
          >
            <Text>
              <FormattedMessage
                id="browse-twitch"
                defaultMessage="Browse Twitch"
              />
            </Text>
          </Button>
        </StyledLayout>
      </Layout>
    );
  }
}

export const ProfileEmptyState = extendInteractionMedium(
  withTracking(ProfileEmptyStateBase),
  INTERACTION_MEDIUM,
);
