import * as React from 'react';
const Clipboard = require('react-clipboard.js').default;
import {
  Text,
  TextType,
  Color,
  InjectLayout,
  Display,
  AlignItems,
  FontSize,
} from 'twitch-core-ui';

import { TrackingProps, withTracking } from 'mweb/common/tracking/withTracking';

export interface ShareSheetItemProps extends TrackingProps {
  displayName: string;
  interactionContent: string;
  url: string;
  handleShare: () => void;
  isClipboard?: true;
}

export class ShareSheetItemBase extends React.PureComponent<
  ShareSheetItemProps,
  {}
> {
  get clipboardItem(): JSX.Element {
    return (
      <Clipboard
        onSuccess={this.props.trackClick(
          { interactionContent: this.props.interactionContent },
          this.props.handleShare,
        )}
        option-text={() => this.props.url}
        component="a"
      >
        <InjectLayout
          display={Display.Flex}
          alignItems={AlignItems.Center}
          padding={{ x: 1, y: 0.5 }}
          fullWidth
        >
          <span>
            {this.props.children}
            <InjectLayout padding={{ left: 1 }}>
              <Text
                type={TextType.Span}
                color={Color.Base}
                fontSize={FontSize.Size4}
              >
                {this.props.displayName}
              </Text>
            </InjectLayout>
          </span>
        </InjectLayout>
      </Clipboard>
    );
  }

  get shareItem(): JSX.Element {
    return (
      <InjectLayout
        display={Display.Flex}
        alignItems={AlignItems.Center}
        padding={{ x: 1, y: 0.5 }}
        fullWidth
      >
        <a
          onClick={this.props.trackClick(
            { interactionContent: this.props.interactionContent },
            this.props.handleShare,
          )}
          target="_blank"
          rel="noopener noreferrer"
          href={this.props.url}
        >
          {this.props.children}
          <InjectLayout padding={{ left: 1 }}>
            <Text
              type={TextType.Span}
              color={Color.Base}
              fontSize={FontSize.Size4}
            >
              {this.props.displayName}
            </Text>
          </InjectLayout>
        </a>
      </InjectLayout>
    );
  }

  render(): JSX.Element {
    return this.props.isClipboard ? this.clipboardItem : this.shareItem;
  }
}

export const ShareSheetItem = withTracking(ShareSheetItemBase);
