import * as React from 'react';
import SpinKit from 'react-spinkit';

if (process.env.BROWSER) {
  require('./spinner.sass');
}

interface SpinnerProps {
  name: 'cube-grid' | 'rotating-plane';
  wrapperClassName: string;
}

export default class Spinner extends React.Component<SpinnerProps, {}> {
  render(): JSX.Element {
    return (
      <div className={this.props.wrapperClassName}>
        <SpinKit name={this.props.name} fadeIn="half" color="#6441a4" />
      </div>
    );
  }
}
