import * as React from 'react';

interface CopyProps {
  height: number;
  width: number;
}

export function Copy(props: CopyProps): React.ReactElement<CopyProps> {
  const style = {
    height: props.height,
    width: props.width,
    background: '#6441a4',
  };
  return (
    <svg style={style} viewBox="0 0 32 32" id="icon_copy">
      <g fillRule="evenodd">
        <path
          fill="white"
          d="M9 19.607l4.755-4.755 3.535 3.535-4.754 4.755L9 19.607zm1.439-.025l4.023-4.023 2.121 2.121-4.023 4.024-2.121-2.122zM14.852 13.755L19.607 9l3.535 3.536-4.755 4.754-3.535-3.535zm.707.707l4.023-4.023 2.122 2.12-4.024 4.024-2.121-2.121z"
        />
        <path
          fill="white"
          d="M12.987 17.741l4.754-4.754 1.414 1.414-4.754 4.754z"
        />
      </g>
    </svg>
  );
}
