import * as React from 'react';

interface FacebookProps {
  height: number;
  width: number;
}

export function Facebook(
  props: FacebookProps,
): React.ReactElement<FacebookProps> {
  const style = {
    height: props.height,
    width: props.width,
    background: '#3b5998',
  };
  return (
    <svg viewBox="0 0 32 32" style={style}>
      <path
        fill="white"
        clipRule="evenodd"
        d="M16.842 24v-6.842h2.653l.398-2.667h-3.051V12.79c0-.772.247-1.298 1.526-1.298L20 11.49V9.105A25.285 25.285 0 0 0 17.623 9c-2.353 0-3.963 1.243-3.963 3.525v1.967H11v2.666h2.66V24h3.182"
        fillRule="evenodd"
      />
    </svg>
  );
}
