import * as React from 'react';

interface RedditProps {
  height: number;
  width: number;
}

export function Reddit(props: RedditProps): React.ReactElement<RedditProps> {
  const style = {
    height: props.height,
    width: props.width,
    background: '#ff611c',
  };
  return (
    <svg style={style} viewBox="0 0 32 32" id="icon_reddit">
      <path
        fill="white"
        d="M21.998 8.692c.545 0 .988.447.988.994a.992.992 0 0 1-.987.995.991.991 0 0 1-.987-.995c0-.547.442-.994.987-.994h-.001zm-.5 5.159c-1.38-.895-3.162-1.418-5.07-1.494l1.047-3.335 2.85.675c.003.923.75 1.671 1.674 1.676a1.683 1.683 0 0 0 1.674-1.687A1.683 1.683 0 0 0 22 8c-.688 0-1.28.42-1.538 1.018l-3.139-.744a.342.342 0 0 0-.406.233l-1.208 3.842c-2.005.038-3.887.567-5.328 1.502a2.014 2.014 0 0 0-1.347-.518A2.042 2.042 0 0 0 7 15.38c0 .72.376 1.386.992 1.757-.03.191-.045.386-.045.58 0 1.465.85 2.83 2.396 3.845a8.483 8.483 0 0 0 1.62.822c2.509.964 6.692.602 7.952 0 1.26-.601 1.128-.498 1.62-.822 1.545-1.015 2.396-2.38 2.396-3.844 0-.195-.015-.39-.045-.581a2.049 2.049 0 0 0-1.04-3.805c-.499 0-.979.185-1.348.519zm-5.56 7.327c1.333 0 2.284-.294 2.887-.901a.348.348 0 0 0 0-.49.342.342 0 0 0-.486 0c-.468.47-1.26.699-2.4.699-1.141 0-1.932-.229-2.4-.698a.342.342 0 0 0-.486 0 .347.347 0 0 0 0 .489c.603.607 1.553.901 2.886.901zm2.695-5.688a1.245 1.245 0 0 0-1.238 1.248c0 .686.555 1.246 1.238 1.246a1.245 1.245 0 0 0 1.239-1.247c0-.687-.556-1.246-1.239-1.246zm-5.39.001c-.682 0-1.237.559-1.237 1.247 0 .686.555 1.245 1.238 1.245.682 0 1.237-.559 1.237-1.245 0-.688-.555-1.247-1.237-1.247z"
        fillRule="evenodd"
      />
    </svg>
  );
}
