import * as React from 'react';
import { FormattedMessage } from 'react-intl';

import { withTracking, TrackingProps } from 'mweb/common/tracking/withTracking';

export const INTERACTION_CONTENT_SWITCH_TO_DESKTOP = 'switch_to_desktop_mode';

interface SwitchToDesktopOwnProps {
  switchToDesktop: React.EventHandler<React.MouseEvent<HTMLAnchorElement>>;
}

export interface SwitchToDesktopProps
  extends SwitchToDesktopOwnProps,
    TrackingProps {}

export class SwitchToDesktopBase extends React.PureComponent<
  SwitchToDesktopProps,
  {}
> {
  render(): JSX.Element {
    return (
      <a
        onClick={this.props.trackClick(
          {
            interactionContent: INTERACTION_CONTENT_SWITCH_TO_DESKTOP,
          },
          this.props.switchToDesktop,
        )}
        className="switch-to-desktop"
        href="#"
      >
        <FormattedMessage
          id="switch-to-desktop--message"
          defaultMessage="Switch to Desktop Mode"
        />
      </a>
    );
  }
}

export const SwitchToDesktop = withTracking(SwitchToDesktopBase);
