import once from 'lodash-es/once';

import {
  BaseVideoPlayer,
  BaseVideoPlayerProps,
} from 'mweb/common/components/videoPlayer/base';
import { withLatencyTracker } from 'mweb/common/latency/withLatencyTracker';
import {
  withCustomLatency,
  CustomLatencyProps,
} from 'mweb/common/latency/withCustomLatency';

export interface ChannelVideoPlayerProps
  extends BaseVideoPlayerProps,
    Twitch.ChannelPlayerOptions,
    CustomLatencyProps {
  channel: string;
}

export class ChannelVideoPlayerBase extends BaseVideoPlayer<
  ChannelVideoPlayerProps
> {
  static displayName: string = 'ChannelVideoPlayer';

  contentShowingCount: number = 0;

  trackPlayerReady: EventListener = once(
    this.props.reportLatencyEvent('playerReady'),
  );
  trackPlayerPlaying: EventListener = once(
    this.props.reportLatencyEvent('playerPlay'),
  );

  componentWillReceiveProps(nextProps: ChannelVideoPlayerProps): void {
    if (this.player && this.props.channel !== nextProps.channel) {
      this.player.setChannel(nextProps.channel);
    }
  }

  get playerParams(): Twitch.ChannelPlayerOptions {
    return {
      channel: this.props.channel,
    };
  }
}

export const ChannelVideoPlayer = withCustomLatency(
  withLatencyTracker(ChannelVideoPlayerBase),
);
