import once from 'lodash-es/once';

import {
  BaseVideoPlayer,
  BaseVideoPlayerProps,
} from 'mweb/common/components/videoPlayer/base';
import { withLatencyTracker } from 'mweb/common/latency/withLatencyTracker';
import {
  withCustomLatency,
  CustomLatencyProps,
} from 'mweb/common/latency/withCustomLatency';

export interface VODVideoPlayerProps
  extends ObjectOmit<BaseVideoPlayerProps, 'hostChannel'>,
    Twitch.VODPlayerOptions,
    CustomLatencyProps {
  vodID: string;
  vodInitialOffset: string | undefined;
}

export class VODVideoPlayerBase extends BaseVideoPlayer<VODVideoPlayerProps> {
  static displayName: string = 'VODVideoPlayer';

  contentShowingCount: number = 0;

  trackPlayerReady: EventListener = once(
    this.props.reportLatencyEvent('playerReady'),
  );
  trackPlayerPlaying: EventListener = once(
    this.props.reportLatencyEvent('playerPlay'),
  );

  get playerParams(): Twitch.VODPlayerOptions {
    return {
      video: `v${this.props.vodID}`,
      time: this.props.vodInitialOffset,
    };
  }
}

export const VODVideoPlayer = withCustomLatency(
  withLatencyTracker(VODVideoPlayerBase),
);
