import * as React from 'react';
import { connect } from 'react-redux';
import Helmet from 'react-helmet';

import { buildDeepLinkURL } from 'mweb/common/utils/deepLink';
import { RootState } from 'mweb/common/reducers/root';

export interface HeaderStateProps {
  referrer: string;
}

export interface HeaderOwnProps {
  path: string;
}

export const VIEWPORT_VALUE =
  'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover';
export const FAVICON_LOCATION = '//twitch.tv/favicon.ico';
export const FAVICON_TYPE = 'image/x-icon';
export const APPLE_APP_ID = '460177396';
export const APPLE_TOUCH_ICON_PATH = '/apple-touch-icon.png';
export const ANDROID_PACKAGE_NAME = 'tv.twitch.android.app';
export const NATIVE_APP_NAME = 'Twitch';

export interface HeaderProps extends HeaderStateProps, HeaderOwnProps {}

export function Head({ referrer, path }: HeaderProps): JSX.Element {
  const intentURL = buildDeepLinkURL({
    path,
    referrer,
  });
  return (
    <Helmet defaultTitle="Twitch">
      <link rel="shortcut icon" href={FAVICON_LOCATION} type={FAVICON_TYPE} />
      <link rel="apple-touch-icon" href={APPLE_TOUCH_ICON_PATH} />
      <meta name="viewport" content={VIEWPORT_VALUE} />
      <meta property="al:ios:url" content={intentURL} />
      <meta property="al:ios:app_store_id" content={APPLE_APP_ID} />
      <meta property="al:ios:app_name" content={NATIVE_APP_NAME} />
      <meta property="al:android:url" content={intentURL} />
      <meta property="al:android:package" content={ANDROID_PACKAGE_NAME} />
      <meta property="al:android:app_name" content={NATIVE_APP_NAME} />
      <meta property="og:type" content="website" />
    </Helmet>
  );
}

function mapStateToProps(state: RootState): HeaderStateProps {
  return {
    referrer: state.app.url,
  };
}

export default connect(mapStateToProps)(Head) as React.ComponentClass<
  HeaderOwnProps
>;
