import * as React from 'react';

import {
  ContextTypes,
  contextTypeValidator,
} from 'mweb/common/utils/contextTypeValidator';
import { LatencyReporter } from 'mweb/common/latency/latencyReporter';

export interface LatencyContext {
  latencyReporter: LatencyReporter;
}

interface LatencyProviderDispatchProps {}

interface LatencyProviderOwnProps {
  latencyReporter: LatencyReporter;
}

interface LatencyProviderProps
  extends LatencyProviderOwnProps,
    LatencyProviderDispatchProps {}

export class LatencyProvider extends React.Component<LatencyProviderProps, {}> {
  static childContextTypes: ContextTypes<LatencyContext> = {
    latencyReporter: contextTypeValidator,
  };

  getChildContext = (): LatencyContext => {
    return {
      latencyReporter: this.props.latencyReporter,
    };
  };

  render(): JSX.Element {
    return React.Children.only(this.props.children);
  }
}
