export enum VideoType {
  Archive = 'archive',
  Clip = 'clip',
  Highlight = 'highlight',
  PastPremiere = 'past_premiere',
  Upload = 'upload',
}

export type VODVideoType =
  | VideoType.Archive
  | VideoType.Highlight
  | VideoType.PastPremiere
  | VideoType.Upload;

export interface BaseVideoDetails {
  readonly id: string;
  readonly thumbnailURL: string;
  readonly date: number;
  readonly viewCount: number;
  readonly length: number;
  readonly formattedLength: string;
  readonly channel: string | undefined;
  readonly title: string | undefined;
  readonly game: string | undefined;
  readonly videoType: VideoType | undefined;
}
