import { combineReducers } from 'redux';
import { Action } from 'mweb/common/actions/root';
import { EVENTS_DATA_EVENT_LOADED_ACTION_TYPE } from 'mweb/common/actions/data/events';

export const DEFAULT_EVENT_COVER_IMAGE_URL_TEMPLATE =
  'https://static-cdn.jtvnw.net/twitch-event-images/defaults/hills-{width}x{height}';

export enum EventType {
  SingleEvent = 'SingleEvent',
  PremiereEvent = 'PremiereEvent',
}

export enum PremiereStatus {
  Unscheduled = 'UNSCHEDULED',
  Scheduled = 'SCHEDULED',
  Cancelled = 'CANCELLED',
  Started = 'STARTED',
  Success = 'SUCCESS',
  Failed = 'FAILED',
  Unknown = 'UNKOWN',
}

export interface EventModel {
  readonly type: EventType;
  readonly id: string;
  readonly startTime: number;
  readonly endTime: number;
  readonly coverImageTemplateURL: string;
  readonly description: string;
  readonly title: string;
  readonly channel: string;
  readonly game?: string;
}

interface PremiereModel {
  readonly id: string;
  readonly status: PremiereStatus;
  readonly vodID?: string;
}

export interface PremiereEventModel extends EventModel {
  readonly type: EventType.PremiereEvent;
  readonly premiere: PremiereModel;
}

export interface SingleEventModel extends EventModel {
  readonly type: EventType.SingleEvent;
}

export interface EventModelMap {
  readonly [eventId: string]: EventModel;
}

export interface EventsState {
  readonly eventDetails: EventModelMap;
}

export function eventDetails(
  state: EventModelMap = {},
  action: Action,
): EventModelMap {
  switch (action.type) {
    case EVENTS_DATA_EVENT_LOADED_ACTION_TYPE:
      return {
        ...state,
        [action.payload.event.id]: action.payload.event,
      };
    default:
      return state;
  }
}

export function buildEventsReducer(): (
  state: EventsState | undefined,
  action: Action,
) => EventsState {
  return combineReducers<EventsState>({
    eventDetails,
  });
}
