import { combineReducers } from 'redux';

import { Action } from 'mweb/common/actions/root';
import {
  buildChannelsReducer,
  ChannelsState,
} from 'mweb/common/reducers/data/channels';
import { buildClipsReducer, ClipsState } from 'mweb/common/reducers/data/clips';
import {
  buildEventsReducer,
  EventsState,
} from 'mweb/common/reducers/data/events';
import { buildGamesReducer, GamesState } from 'mweb/common/reducers/data/games';
import { buildVODsReducer, VODsState } from 'mweb/common/reducers/data/vods';

export interface DataRootState {
  readonly channels: ChannelsState;
  readonly clips: ClipsState;
  readonly events: EventsState;
  readonly games: GamesState;
  readonly vods: VODsState;
}

export function buildDataRootReducer(): (
  state: DataRootState | undefined,
  action: Action,
) => DataRootState {
  return combineReducers<DataRootState>({
    channels: buildChannelsReducer(),
    clips: buildClipsReducer(),
    vods: buildVODsReducer(),
    events: buildEventsReducer(),
    games: buildGamesReducer(),
  });
}
