import {
  NetInfo,
  PLATFORM_SWITCHED_TO_CLIENT_ACTION_TYPE,
} from 'mweb/common/actions/platform';
import { Action } from 'mweb/common/actions/root';

export enum OS {
  Android = 'Android',
  Microsoft = 'Microsoft',
  iOS = 'iOS',
  Fire = 'Fire',
  Other = 'Other OS',
  Unknown = 'Unknown OS',
}

export enum Browser {
  Chrome = 'Chrome',
  Safari = 'Safari',
  Edge = 'Edge',
  Silk = 'Silk',
  Other = 'Other Browser',
  Unknown = 'Unknown Browser',
}

export interface DeviceState {
  readonly deviceID: string;
  readonly sessionID: string;
  readonly os: OS;
  readonly browser: Browser;
  readonly netInfo: NetInfo;
}

const DEFAULT_DEVICE_STATE: DeviceState = {
  deviceID: '',
  sessionID: '',
  os: OS.Unknown,
  browser: Browser.Unknown,
  netInfo: {} as NetInfo,
};

export function device(
  state: DeviceState = DEFAULT_DEVICE_STATE,
  action: Action,
): DeviceState {
  switch (action.type) {
    case PLATFORM_SWITCHED_TO_CLIENT_ACTION_TYPE:
      return {
        ...state,
        os: action.payload.os,
        browser: action.payload.browser,
        netInfo: action.payload.netInfo,
      };
    default:
      return state;
  }
}
