import { Action } from 'mweb/common/actions/root';
import { CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/channelDirectory';

export interface ChannelDirectoryPageState {
  readonly currentGameAlias: string | undefined;
}

const DEFAULT_CHANNEL_DIRECTORY_PAGE_STATE: ChannelDirectoryPageState = {
  currentGameAlias: undefined,
};

export function channelDirectoryPage(
  state: ChannelDirectoryPageState = DEFAULT_CHANNEL_DIRECTORY_PAGE_STATE,
  action: Action,
): ChannelDirectoryPageState {
  switch (action.type) {
    case CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE:
      return {
        ...state,
        currentGameAlias: action.payload.gameAlias,
      };
    default:
      return state;
  }
}
