import { Action } from 'mweb/common/actions/root';
import {
  CHANNEL_PROFILE_PAGE_CHANNEL_UPDATED_ACTION_TYPE,
  CHANNEL_PROFILE_PAGE_REDIRECTED_AS_OFFLINE,
} from 'mweb/common/actions/pages/channelProfile';
export interface ChannelProfilePageState {
  readonly currentChannel: string;
  redirectedAsOffline: boolean;
}

export const DEFAULT_CHANNEL_PROFILE_PAGE_STATE: ChannelProfilePageState = {
  currentChannel: '',
  redirectedAsOffline: false,
};

export function channelProfilePage(
  state: ChannelProfilePageState = DEFAULT_CHANNEL_PROFILE_PAGE_STATE,
  action: Action,
): ChannelProfilePageState {
  switch (action.type) {
    case CHANNEL_PROFILE_PAGE_REDIRECTED_AS_OFFLINE:
      return { ...state, redirectedAsOffline: true };
    case CHANNEL_PROFILE_PAGE_CHANNEL_UPDATED_ACTION_TYPE:
      return { ...state, currentChannel: action.payload.channel };
    default:
      return state;
  }
}
