import { logger } from 'tachyon-logger';
import {
  CHANNELS_DATA_CHANNEL_HOSTING_STATUS_UPDATED_ACTION_TYPE,
  CHANNELS_DATA_CHANNEL_LOADED_ACTION_TYPE,
  CHANNELS_DATA_PAGE_LOADED_ACTION_TYPE,
} from 'mweb/common/actions/data/channels';
import {
  CHANNEL_VIEWER_PAGE_CHANNEL_UPDATED_ACTION_TYPE,
  CHANNEL_VIEWER_PAGE_LIVE_TO_VOD_PARAMS_CAPTURED_ACTION_TYPE,
  CHANNEL_VIEWER_PAGE_LIVE_TO_VOD_REDIRECTED_ACTION_TYPE,
  CHANNEL_VIEWER_PAGE_LIVE_TO_VOD_STREAM_ID_CLEARED_ACTION_TYPE,
} from 'mweb/common/actions/pages/channelViewer';
import { Action } from 'mweb/common/actions/root';
import { ChannelOnlineStatus } from 'mweb/common/reducers/data/channels';

export interface ChannelViewerPageState {
  readonly currentChannel: string;
  readonly hostedChannel: string;
  readonly showChat: boolean | undefined;
  readonly liveToVODStreamID: string | undefined;
  readonly liveToVODTargetVODid: string;
}

export const DEFAULT_CHANNEL_VIEWER_PAGE_STATE: ChannelViewerPageState = {
  currentChannel: '',
  hostedChannel: '',
  showChat: undefined,
  liveToVODStreamID: undefined,
  liveToVODTargetVODid: '',
};

export function channelViewerPage(
  state: ChannelViewerPageState = DEFAULT_CHANNEL_VIEWER_PAGE_STATE,
  action: Action,
): ChannelViewerPageState {
  switch (action.type) {
    case CHANNEL_VIEWER_PAGE_CHANNEL_UPDATED_ACTION_TYPE:
      const channel = action.payload.channel || '';
      if (!channel) {
        logger.warn('Strangely transitioning to nonexistent channel.');
      }
      return {
        ...state,
        currentChannel: channel.toLowerCase(),
        hostedChannel: '',
        liveToVODStreamID: undefined,
      };
    case CHANNELS_DATA_CHANNEL_HOSTING_STATUS_UPDATED_ACTION_TYPE:
      if (action.payload.channel === state.currentChannel) {
        return {
          ...state,
          hostedChannel: action.payload.hostedChannel,
        };
      }
      return state;
    case CHANNEL_VIEWER_PAGE_LIVE_TO_VOD_PARAMS_CAPTURED_ACTION_TYPE:
      return {
        ...state,
        liveToVODStreamID: action.payload.stream_id,
      };
    case CHANNEL_VIEWER_PAGE_LIVE_TO_VOD_REDIRECTED_ACTION_TYPE:
      return {
        ...state,
        liveToVODTargetVODid: action.payload.vodID,
      };
    case CHANNEL_VIEWER_PAGE_LIVE_TO_VOD_STREAM_ID_CLEARED_ACTION_TYPE:
      return {
        ...state,
        liveToVODStreamID: undefined,
      };
    case CHANNELS_DATA_CHANNEL_LOADED_ACTION_TYPE:
      if (action.payload.channel.name === state.currentChannel) {
        return {
          ...state,
          showChat:
            state.showChat ||
            action.payload.channel.onlineStatus === ChannelOnlineStatus.Online,
        };
      }
      return state;
    case CHANNELS_DATA_PAGE_LOADED_ACTION_TYPE:
      if (action.payload.channelDetails[state.currentChannel]) {
        return {
          ...state,
          showChat:
            state.showChat ||
            action.payload.channelDetails[state.currentChannel].onlineStatus ===
              ChannelOnlineStatus.Online,
        };
      }
      return state;
    default:
      return state;
  }
}
