import { Action } from 'mweb/common/actions/root';
import { CHAT_EMBED_PAGE_CHANNEL_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/chatEmbed';

export interface ChatEmbedPageState {
  readonly currentChannel: string;
}

const DEFAULT_CHAT_EMBED_PAGE_STATE: ChatEmbedPageState = {
  currentChannel: '',
};

export function chatEmbedPage(
  state: ChatEmbedPageState = DEFAULT_CHAT_EMBED_PAGE_STATE,
  action: Action,
): ChatEmbedPageState {
  switch (action.type) {
    case CHAT_EMBED_PAGE_CHANNEL_UPDATED_ACTION_TYPE:
      return {
        ...state,
        currentChannel: action.payload.channel,
      };
    default:
      return state;
  }
}
