import { Action } from 'mweb/common/actions/root';
import { EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/eventDetails';

export interface EventDetailsPageState {
  readonly currentEventID: string;
}

const DEFAULT_EVENT_DETAILS_PAGE_STATE: EventDetailsPageState = {
  currentEventID: '',
};

export function eventDetailsPage(
  state: EventDetailsPageState = DEFAULT_EVENT_DETAILS_PAGE_STATE,
  action: Action,
): EventDetailsPageState {
  switch (action.type) {
    case EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE:
      return {
        ...state,
        currentEventID: action.payload.eventID,
      };
    default:
      return state;
  }
}
