import {
  channelProfilePage,
  ChannelProfilePageState,
} from 'mweb/common/reducers/pages/channelProfile';
import { combineReducers } from 'redux';

import { Action } from 'mweb/common/actions/root';
import {
  chatEmbedPage,
  ChatEmbedPageState,
} from 'mweb/common/reducers/pages/chatEmbed';
import {
  channelDirectoryPage,
  ChannelDirectoryPageState,
} from 'mweb/common/reducers/pages/channelDirectory';
import {
  channelViewerPage,
  ChannelViewerPageState,
} from 'mweb/common/reducers/pages/channelViewer';
import {
  eventDetailsPage,
  EventDetailsPageState,
} from 'mweb/common/reducers/pages/eventDetails';
import {
  vodViewerPage,
  VODViewerPageState,
} from 'mweb/common/reducers/pages/vodViewer';
import { resetPageReducerOnNavigation } from 'mweb/common/utils/resetPageReducerOnNavigation';
import { Location } from 'mweb/common/reducers/app';

export interface PagesRootState {
  readonly chatEmbed: ChatEmbedPageState;
  readonly channelDirectory: ChannelDirectoryPageState;
  readonly channelViewer: ChannelViewerPageState;
  readonly eventDetails: EventDetailsPageState;
  readonly vodViewer: VODViewerPageState;
  readonly channelProfile: ChannelProfilePageState;
}

export function buildPagesRootReducer(): (
  state: PagesRootState,
  action: Action,
) => PagesRootState {
  return combineReducers<PagesRootState>({
    chatEmbed: chatEmbedPage,
    channelDirectory: resetPageReducerOnNavigation(
      channelDirectoryPage,
      Location.DirectoryGame,
    ),
    channelViewer: resetPageReducerOnNavigation(
      channelViewerPage,
      Location.Channel,
    ),
    eventDetails: resetPageReducerOnNavigation(
      eventDetailsPage,
      Location.EventDetails,
    ),
    vodViewer: resetPageReducerOnNavigation(vodViewerPage, Location.VOD),
    channelProfile: resetPageReducerOnNavigation(
      channelProfilePage,
      Location.ChannelProfile,
    ),
  });
}
