import { Action } from 'mweb/common/actions/root';
import { VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/vodViewer';

export interface VODViewerPageState {
  readonly currentVODid: string;
}

export const DEFAULT_VOD_VIEWER_PAGE_STATE: VODViewerPageState = {
  currentVODid: '',
};

export function vodViewerPage(
  state: VODViewerPageState = DEFAULT_VOD_VIEWER_PAGE_STATE,
  action: Action,
): VODViewerPageState {
  switch (action.type) {
    case VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE:
      return {
        ...state,
        currentVODid: action.payload.vodID,
      };
    default:
      return state;
  }
}
