import { Location } from 'mweb/common/reducers/app';

export const ROUTES: [{ route: string; location: Location }] = [
  { route: '/', location: Location.DirectoryMainGame },
  { route: '/directory', location: Location.DirectoryMainGame },
  { route: '/directory/all', location: Location.DirectoryGame },
  { route: '/directory/game/:gameAlias', location: Location.DirectoryGame },
  { route: '/:channel/v/:vodID', location: Location.VOD },
  { route: '/videos/:vodID', location: Location.VOD },
  { route: '/:channel', location: Location.Channel },
  {
    route:
      '/:channel/:subPath(profile|clips|collections|events|followers|following)',
    location: Location.ChannelProfile,
  },
  { route: '/:channel/videos/:type?', location: Location.ChannelProfile },
  { route: '/:channel/rochat', location: Location.ChatEmbed },
  { route: '/events/:eventID', location: Location.EventDetails },

  // Order matters, keep this at the bottom so it doesn't override a real route.
  { route: '/:up/:sell/:this?', location: Location.Upsell },
];
