import { RootState } from 'mweb/common/reducers/root';
import { GameDetails } from 'mweb/common/reducers/data/games';

export function getGameDetails(
  state: RootState,
  gameName: string,
): GameDetails | undefined {
  return state.data.games.gameDetails[gameName];
}

export function convertGameAlias(
  state: RootState,
  gameAlias: string,
): string | undefined {
  return state.data.games.gameNameLookup[gameAlias];
}

export function getGameNameForGameAlias(
  state: RootState,
  gameAlias: string,
): string | undefined {
  // see if the alias is the canonical name
  const game = getGameDetails(state, gameAlias);
  if (game) {
    return game.name;
  }

  // otherwise see if an alias exists
  return convertGameAlias(state, gameAlias);
}

export function getGameDetailsForGameAlias(
  state: RootState,
  gameAlias: string,
): GameDetails | undefined {
  // see if the alias is the canonical name
  const game = getGameDetails(state, gameAlias);
  if (game) {
    return game;
  }

  // otherwise see if an alias exists
  const gameName = convertGameAlias(state, gameAlias);
  return gameName ? getGameDetails(state, gameName) : undefined;
}
