import { RootState } from 'mweb/common/reducers/root';
import {
  ExperimentNames,
  ExperimentData,
  ExperimentGroups,
} from 'mweb/common/actions/experiments';

export function getActiveExperimentData(
  state: RootState,
  name: ExperimentNames,
): ExperimentData {
  const experimentData = (state.experiments.activeExperiments as Indexable<
    ExperimentData
  >)[name];

  // If no data, edge case where Minexperiment failed to load.
  // Fall back to control.
  return (
    experimentData || {
      uuid: undefined,
      group: ExperimentGroups.Control,
      name,
    }
  );
}

export function isExperimentDecisionRecorded(
  state: RootState,
  name: ExperimentNames,
): boolean {
  return !!state.experiments.recordedDecisions[name];
}
