import { RootState } from 'mweb/common/reducers/root';
import { Location } from 'mweb/common/reducers/app';

export const PLATFORM_FOR_SPADE = 'mobile_web';

export interface SpadeData {
  readonly platform: typeof PLATFORM_FOR_SPADE;
  readonly language: string;
  readonly medium: string | undefined;
  readonly content: string | undefined;
  readonly gitHash: string;
}

export interface SpadeDataWithTime extends SpadeData {
  readonly time: number; // seconds since epoch
}

export interface SpadeDataWithLocation extends SpadeData {
  readonly location: Location;
}

export interface SpadeDataWithTimeAndLocation
  extends SpadeDataWithTime,
    SpadeDataWithLocation {}

export function getBaseSpadeData(state: RootState): SpadeData {
  return {
    medium: state.tracking.medium,
    content: state.tracking.content,
    platform: PLATFORM_FOR_SPADE,
    language: state.intl.locale,
    gitHash: state.app.gitHash,
  };
}

export function getSpadeDataWithTime(state: RootState): SpadeDataWithTime {
  return {
    ...getBaseSpadeData(state),
    time: new Date().valueOf() / 1000,
  };
}

export function getSpadeDataWithLocation(
  state: RootState,
): SpadeDataWithLocation {
  return {
    ...getBaseSpadeData(state),
    location: state.app.location,
  };
}

export function getSpadeDataWithTimeAndLocation(
  state: RootState,
): SpadeDataWithTimeAndLocation {
  return {
    ...getBaseSpadeData(state),
    location: state.app.location,
    time: new Date().valueOf() / 1000,
  };
}
