import {
  getSpadeDataWithTimeAndLocation,
  SpadeDataWithTimeAndLocation,
} from 'mweb/common/selectors/tracking/base';
import { RootState } from 'mweb/common/reducers/root';
import { ChannelsDataPageLoadedEventPayload } from 'mweb/common/actions/data/channels';
import { GamesDataPageLoadedEventPayload } from 'mweb/common/actions/data/games';

export interface DirectoryPageLoadedSpadeData
  extends SpadeDataWithTimeAndLocation {
  readonly cards_received: number;
  readonly page_load_id: string;
  readonly game: string;
}

export function getChannelsPageLoadedSpadeData(
  state: RootState,
  payload: ChannelsDataPageLoadedEventPayload,
): DirectoryPageLoadedSpadeData {
  return {
    ...getSpadeDataWithTimeAndLocation(state),
    cards_received: payload.channelsLoaded,
    game: payload.game,
    page_load_id: state.tracking.pageLoadID,
  };
}

export function getGamesPageLoadedSpadeData(
  state: RootState,
  payload: GamesDataPageLoadedEventPayload,
): DirectoryPageLoadedSpadeData {
  return {
    ...getSpadeDataWithTimeAndLocation(state),
    cards_received: payload.gamesLoaded,
    game: '',
    page_load_id: state.tracking.pageLoadID,
  };
}
